// This program computes the short time energy of a signal using
// Rectangular and Hamming window
//OS: windows 7
//Scilab: 5.5.2
//
clc;
close;
clear;
[y,Fs]=wavread('C:\Users\ACER\Desktop\Two.wav');
t=(0:length(y)-1)/Fs; // Changing x axixs in to time in seconds
subplot(311)
plot(t,y)
xlabel('Time in seconds')
title('Original signal')
frame_durn = 0.02;   // Duration of frame in seconds
frame_len=Fs*frame_durn; // Length of frame
Rect_window=window('re',frame_len);

frame_shift=Fs*frame_durn/2; // 50% overlapping for Rectangular window
no_of_frames=floor(length(y)/frame_shift); // Computing total number of frames

frame_start=1;
frame_end=frame_start+frame_len-1;
for j=1:no_of_frames
    En(j)=0;
    if frame_end>=length(y) then    // Adustment for the last segment
        frame_end=length(y)
        frame_len=frame_end-frame_start;
    end
 
    
    segment=y(frame_start:frame_end);
    for k=1:frame_len
        En(j)=En(j)+(segment(k)*Rect_window(k))^2  // Computing the STE
    end
    frame_start=frame_start+frame_shift;
    frame_end=frame_end+frame_shift;
        
end



subplot(312)
plot(En)
title('Short Time Enery using Rectangular window')
xlabel('Segment number')
ylabel('STE')

////////////////////////////////////////////////

// For Hamming window
Ham_window=window('hm',frame_len);

frame_shift=Fs*frame_durn/4; // 75% overlapping for Hamming window
no_of_frames=floor(length(y)/frame_shift);

frame_start=1;
frame_end=frame_start+frame_len-1;
for j=1:no_of_frames
    En1(j)=0;
    if frame_end>=length(y) then
        frame_end=length(y)
        frame_len=frame_end-frame_start;
    end
    
    segment=y(frame_start:frame_end);
    for k=1:frame_len
        En1(j)=En1(j)+(segment(k)*Ham_window(k))^2
    end                     // Computing STE using Hamming window
    frame_start=frame_start+frame_shift;
    frame_end=frame_end+frame_shift;
        
end

subplot(313)
plot(En1)
title('Short Time Enery using Hamming window')
xlabel('Segment number')
ylabel('STE')


